# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .jwt_auth_config_claims_item import JwtAuthConfigClaimsItem


class JwtAuthConfig(UniversalBaseModel):
    """
    Configure JWT-based authentication using JWKS
    """

    type: typing.Literal["jwt_auth"] = pydantic.Field(default="jwt_auth")
    """
    +value=jwt_auth
    """

    integration_fqn: str = pydantic.Field()
    """
    FQN of the JWT Auth integration. If you can't find your integration here,
    add it through the [Integrations](/integrations) page
    """

    enable_login: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enable login for the service
    """

    claims: typing.Optional[typing.List[JwtAuthConfigClaimsItem]] = pydantic.Field(default=None)
    """
    List of key-value pairs of claims to verify in the JWT token
    """

    bypass_auth_paths: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of paths that will bypass auth.
    needs to start with a forward slash(/) and should not contain wildcards(*)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
