# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .kafka_sasl_auth import KafkaSaslAuth


class KafkaInputConfig(UniversalBaseModel):
    """
    Describes the configuration for the input Kafka worker
    """

    type: typing.Literal["kafka"] = pydantic.Field(default="kafka")
    """
    +value=kafka
    """

    bootstrap_servers: str = pydantic.Field()
    """
    'Kafka Bootstrap servers - Comma separated list of Kafka brokers "hostname:port" to connect to for bootstrap'
    """

    topic_name: str = pydantic.Field()
    """
    Kafka topic to subscribe to
    """

    consumer_group: str = pydantic.Field()
    """
    The name of the consumer group to join for dynamic partition assignment
    """

    tls: bool = pydantic.Field(default=True)
    """
    TLS configuration for SASL authentication
    """

    wait_time_seconds: typing.Optional[int] = pydantic.Field(default=10)
    """
    Wait timeout for long polling.
    """

    auth: typing.Optional[KafkaSaslAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
