# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .kafka_sasl_auth import KafkaSaslAuth


class KafkaOutputConfig(UniversalBaseModel):
    """
    Describes the configuration for the output Kafka worker
    """

    type: typing.Literal["kafka"] = pydantic.Field(default="kafka")
    """
    +value=kafka
    """

    bootstrap_servers: str = pydantic.Field()
    """
    'Kafka Bootstrap servers - Comma separated list of Kafka brokers "hostname:port" to connect to for bootstrap'
    """

    topic_name: str = pydantic.Field()
    """
    Kafka topic to publish to
    """

    tls: bool = pydantic.Field(default=True)
    """
    TLS configuration for SASL authentication
    """

    auth: typing.Optional[KafkaSaslAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
