# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LibraryName(str, enum.Enum):
    """
    Name of the library for the framework
    """

    TRANSFORMERS = "transformers"
    SENTENCE_TRANSFORMERS = "sentence-transformers"
    DIFFUSERS = "diffusers"

    def visit(
        self,
        transformers: typing.Callable[[], T_Result],
        sentence_transformers: typing.Callable[[], T_Result],
        diffusers: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is LibraryName.TRANSFORMERS:
            return transformers()
        if self is LibraryName.SENTENCE_TRANSFORMERS:
            return sentence_transformers()
        if self is LibraryName.DIFFUSERS:
            return diffusers()
