# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_server_auth import McpServerAuth
from .mcp_server_integration_transport import McpServerIntegrationTransport


class McpServerIntegration(UniversalBaseModel):
    """
    MCP Server
    """

    type: typing.Literal["integration/mcp-server/remote"] = pydantic.Field(default="integration/mcp-server/remote")
    """
    +value=integration/mcp-server/remote
    """

    name: str = pydantic.Field()
    """
    The name of the MCP Server.
    """

    description: str = pydantic.Field()
    """
    Provide a brief description of the purpose of this MCP Server.
    """

    url: str = pydantic.Field()
    """
    The endpoint URL for the MCP Server.
    """

    transport: McpServerIntegrationTransport = pydantic.Field()
    """
    The transport protocol to use for communication with the MCP Server.
    """

    auth_data: typing.Optional[McpServerAuth] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of teams/users who can use this MCP server.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
