# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_server_o_auth2jwt_source import McpServerOAuth2JwtSource


class McpServerOAuth2(UniversalBaseModel):
    """
    OAuth2
    """

    type: typing.Literal["oauth2"] = pydantic.Field(default="oauth2")
    """
    OAuth2 authentication
    """

    authorization_url: str = pydantic.Field()
    """
    URL for the authorization request
    """

    token_url: str = pydantic.Field()
    """
    The endpoint to exchange auth code for tokens.
    """

    scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of scopes to request from the OAuth2 provider.
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    client ID for OAuth2 or the TrueFoundry secret FQN containing the client ID.
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Client secret or the TrueFoundry secret FQN containing the client secret for OAuth2.
    """

    registration_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for dynamic client registration (RFC 7591). If provided, client credentials will be obtained automatically.
    """

    code_challenge_methods_supported: typing.Optional[typing.List[typing.Literal["S256"]]] = pydantic.Field(
        default=None
    )
    """
    List of supported PKCE code challenge methods (S256 only)
    """

    jwt_source: McpServerOAuth2JwtSource = pydantic.Field()
    """
    Source of the JWT token to be used for verification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
