# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .mcp_server_integrations import McpServerIntegrations
from .owned_by import OwnedBy


class McpServerProviderAccount(UniversalBaseModel):
    """
    MCP Server Group
    """

    type: typing.Literal["provider-account/mcp-server-group"] = pydantic.Field(
        default="provider-account/mcp-server-group"
    )
    """
    +value=provider-account/mcp-server-group
    """

    name: str = pydantic.Field()
    """
    The name of the MCP Server Group.
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    List of teams/users who can manage this MCP Server Group. These subjects can add new MCP server integrations, can edit existing ones and can also use the MCP server.
    """

    integrations: typing.List[McpServerIntegrations] = pydantic.Field()
    """
    List of MCP Servers, which are part of this MCP Server Group.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
