# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_tool import McpTool


class McpServerWithFqn(UniversalBaseModel):
    """
    MCP server with FQN
    """

    type: typing.Literal["mcp-server-fqn"] = pydantic.Field(default="mcp-server-fqn")
    """
    The FQN of the MCP server
    """

    integration_fqn: str = pydantic.Field()
    """
    The FQN of the MCP server
    """

    enable_all_tools: bool = pydantic.Field(default=False)
    """
    Whether to enable all tools from the MCP server
    """

    tools: typing.Optional[typing.List[McpTool]] = pydantic.Field(default=None)
    """
    The tools to enable from the MCP server
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
