# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_tool import McpTool


class McpServerWithUrl(UniversalBaseModel):
    """
    MCP server with URL
    """

    type: typing.Literal["mcp-server-url"] = pydantic.Field(default="mcp-server-url")
    """
    The URL of the MCP server
    """

    url: str = pydantic.Field()
    """
    The URL of the MCP server
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The headers to send to the MCP server
    """

    enable_all_tools: bool = pydantic.Field(default=False)
    """
    Whether to enable all tools from the MCP server
    """

    tools: typing.Optional[typing.List[McpTool]] = pydantic.Field(default=None)
    """
    The tools to enable from the MCP server
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
