# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MirrorAction(UniversalBaseModel):
    type: typing.Literal["mirror"] = pydantic.Field(default="mirror")
    """
    +value=mirror
    """

    service_uri: str = pydantic.Field()
    """
    Service uri to mirror to. This is the kubernetes fully qualified domain name that the target service can be reached on
    Eg - For a service called `sample-service` in workspace `ws` this would be `sample-service.ws.svc.cluster.local
    """

    port: int = pydantic.Field()
    """
    Port to redirect the service traffic to
    """

    percentage: int = pydantic.Field()
    """
    Percentage of requests to mirror
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
