# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy


class MlRepoManifest(UniversalBaseModel):
    """
    MLRepo is a repository ML training runs that log params, metrics, plots, images and versioned entities like artifacts, models, prompts, tools, agents
    """

    type: typing.Literal["ml-repo"] = "ml-repo"
    name: str = pydantic.Field()
    """
    Name of the ML Repo.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description for the ML Repo.
    """

    storage_integration_fqn: str = pydantic.Field()
    """
    Storage Integration to store artifacts and models. A storage integration represents a connected blob storage like AWS S3 / Azure Blob Storage / Google Cloud Storage.
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    Users and Teams that have access to MLRepo
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
