# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .parameters import Parameters


class ModelConfiguration(UniversalBaseModel):
    """
    Add a model from Gateway along with parameters to be used for chat completion
    """

    provider: str = pydantic.Field()
    """
    Name of the provider, must be one of the integration providers configured for the Gateway
    """

    model: str = pydantic.Field()
    """
    Name of the model to be used for generations. This model should be available in the provider
    """

    parameters: typing.Optional[Parameters] = pydantic.Field(default=None)
    """
    Parameters to pass to the model when generating
    """

    extra_parameters: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Arbitrary extra parameters to pass to the model when generating
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
