# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ModelType(str, enum.Enum):
    """
    Model Type
    """

    CHAT = "chat"
    COMPLETION = "completion"
    EMBEDDING = "embedding"
    REALTIME = "realtime"
    RERANK = "rerank"
    AUDIO_TRANSCRIPTION = "audio_transcription"
    AUDIO_TRANSLATION = "audio_translation"
    TEXT_TO_SPEECH = "text_to_speech"
    MODERATION = "moderation"
    IMAGE = "image"

    def visit(
        self,
        chat: typing.Callable[[], T_Result],
        completion: typing.Callable[[], T_Result],
        embedding: typing.Callable[[], T_Result],
        realtime: typing.Callable[[], T_Result],
        rerank: typing.Callable[[], T_Result],
        audio_transcription: typing.Callable[[], T_Result],
        audio_translation: typing.Callable[[], T_Result],
        text_to_speech: typing.Callable[[], T_Result],
        moderation: typing.Callable[[], T_Result],
        image: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ModelType.CHAT:
            return chat()
        if self is ModelType.COMPLETION:
            return completion()
        if self is ModelType.EMBEDDING:
            return embedding()
        if self is ModelType.REALTIME:
            return realtime()
        if self is ModelType.RERANK:
            return rerank()
        if self is ModelType.AUDIO_TRANSCRIPTION:
            return audio_transcription()
        if self is ModelType.AUDIO_TRANSLATION:
            return audio_translation()
        if self is ModelType.TEXT_TO_SPEECH:
            return text_to_speech()
        if self is ModelType.MODERATION:
            return moderation()
        if self is ModelType.IMAGE:
            return image()
