# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .nats_user_password_auth import NatsUserPasswordAuth


class NatsInputConfig(UniversalBaseModel):
    """
    Describes the configuration for the input NATS worker
    """

    type: typing.Literal["nats"] = pydantic.Field(default="nats")
    """
    +value=nats
    """

    nats_url: str = pydantic.Field()
    """
    Input NATS URL
    """

    stream_name: str = pydantic.Field()
    """
    Name of the NATS stream
    """

    root_subject: str = pydantic.Field()
    """
    Root subject of input NATS
    """

    consumer_name: str = pydantic.Field()
    """
    Consumer name of input NATS
    """

    wait_time_seconds: int = pydantic.Field(default=19)
    """
    Wait timeout for long polling.
    """

    nats_metrics_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for the NATS metrics endpoint. It is compulsory if you want to use NATS autoscaling.
    """

    auth: typing.Optional[NatsUserPasswordAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
