# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NatsUserPasswordAuth(UniversalBaseModel):
    """
    NATS User Password Authentication
    """

    account_name: str = pydantic.Field(default="$G")
    """
    Name of the NATS account
    """

    user: str = pydantic.Field()
    """
    User for NATS authentication
    """

    password: str = pydantic.Field()
    """
    Password for NATS authentication
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
