# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class NodeSelectorCapacityType(str, enum.Enum):
    """
    Configure what type of nodes to run the app. By default no placement logic is applied.
    "spot_fallback_on_demand" will try to place the application on spot nodes but will fallback to on-demand when spot nodes are not available.
    "spot" will strictly place the application on spot nodes.
    "on_demand" will strictly place the application on on-demand nodes.
    """

    SPOT_FALLBACK_ON_DEMAND = "spot_fallback_on_demand"
    SPOT = "spot"
    ON_DEMAND = "on_demand"

    def visit(
        self,
        spot_fallback_on_demand: typing.Callable[[], T_Result],
        spot: typing.Callable[[], T_Result],
        on_demand: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is NodeSelectorCapacityType.SPOT_FALLBACK_ON_DEMAND:
            return spot_fallback_on_demand()
        if self is NodeSelectorCapacityType.SPOT:
            return spot()
        if self is NodeSelectorCapacityType.ON_DEMAND:
            return on_demand()
