# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .open_ai_moderations_guardrail_config_category_thresholds_value import (
    OpenAiModerationsGuardrailConfigCategoryThresholdsValue,
)
from .openai_api_key_auth import OpenaiApiKeyAuth


class OpenAiModerationsGuardrailConfig(UniversalBaseModel):
    """
    OpenAI Moderation
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/openai-moderations"] = pydantic.Field(
        default="integration/guardrail-config/openai-moderations"
    )
    """
    +value=integration/guardrail-config/openai-moderations
    +sort=50
    +uiType=Hidden
    """

    base_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional custom base URL for OpenAI API. If not provided, the default base URL will be used.
    """

    auth_data: OpenaiApiKeyAuth
    model: str = pydantic.Field(default="omni-moderation-latest")
    """
    The model to use for the OpenAI Moderation API.
    """

    category_thresholds: typing.Optional[typing.Dict[str, OpenAiModerationsGuardrailConfigCategoryThresholdsValue]] = (
        pydantic.Field(default=None)
    )
    """
    Confidence thresholds (0.0-1.0) for each content category. Content scoring above the threshold will be flagged. Lower values are more strict
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
