# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .open_router_api_key_auth import OpenRouterApiKeyAuth
from .open_router_integrations import OpenRouterIntegrations
from .owned_by import OwnedBy


class OpenRouterProviderAccount(UniversalBaseModel):
    """
    OpenRouter Provider Account
    """

    type: typing.Literal["provider-account/openrouter"] = pydantic.Field(default="provider-account/openrouter")
    """
    +value=provider-account/openrouter
    """

    name: str = pydantic.Field()
    """
    The name of the OpenRouter provider account
    """

    auth_data: OpenRouterApiKeyAuth
    integrations: typing.List[OpenRouterIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the OpenRouter provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
