# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .open_ai_integrations import OpenAiIntegrations
from .openai_api_key_auth import OpenaiApiKeyAuth
from .owned_by import OwnedBy


class OpenaiProviderAccount(UniversalBaseModel):
    """
    OpenAI Provider Account
    """

    type: typing.Literal["provider-account/openai"] = pydantic.Field(default="provider-account/openai")
    """
    +value=provider-account/openai
    """

    name: str = pydantic.Field()
    """
    The name of the OpenAI provider account
    """

    auth_data: OpenaiApiKeyAuth
    base_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional custom base URL for OpenAI API
    """

    integrations: typing.List[OpenAiIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the OpenAI provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
