# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OtelExporterGrpcConfig(UniversalBaseModel):
    """
    gRPC Configuration
    """

    type: typing.Literal["grpc"] = pydantic.Field(default="grpc")
    """
    Configuration type
    """

    endpoint: str = pydantic.Field()
    """
    Traces endpoint URL where OpenTelemetry data will be sent (format: https://<host>:<port>)
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    gRPC metadata to include in OpenTelemetry export requests
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
