# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .otel_exporter_http_config_encoding import OtelExporterHttpConfigEncoding


class OtelExporterHttpConfig(UniversalBaseModel):
    """
    HTTP Configuration
    """

    type: typing.Literal["http"] = pydantic.Field(default="http")
    """
    Configuration type
    """

    endpoint: str = pydantic.Field()
    """
    Traces endpoint URL where OpenTelemetry data will be sent (typical format: https://<host>:<port>/<path>/v1/traces)
    """

    encoding: OtelExporterHttpConfigEncoding = pydantic.Field()
    """
    Encoding for OpenTelemetry data
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    HTTP headers to include in OpenTelemetry export requests
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
