# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .palo_alto_prisma_airs_guardrail_config_mode import PaloAltoPrismaAirsGuardrailConfigMode
from .palo_alto_prisma_airs_key_auth import PaloAltoPrismaAirsKeyAuth


class PaloAltoPrismaAirsGuardrailConfig(UniversalBaseModel):
    """
    Palo Alto Prisma AIRS
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/palo-alto-prisma-airs"] = pydantic.Field(
        default="integration/guardrail-config/palo-alto-prisma-airs"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/palo-alto-prisma-airs
    """

    profile_name: str = pydantic.Field()
    """
    The profile name associated with this Guardrail Config.
    """

    mode: typing.Optional[PaloAltoPrismaAirsGuardrailConfigMode] = pydantic.Field(default=None)
    """
    Execution mode for the guardrail. Sync waits for the guardrail check to complete before proceeding. Async triggers the check without waiting. Defaults to sync.
    """

    auth_data: PaloAltoPrismaAirsKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
