# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .pangea_guard_type import PangeaGuardType
from .pangea_key_auth import PangeaKeyAuth


class PangeaGuardrailConfig(UniversalBaseModel):
    """
    Pangea
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/pangea"] = pydantic.Field(
        default="integration/guardrail-config/pangea"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/pangea
    """

    auth_data: PangeaKeyAuth
    guard_type: PangeaGuardType
    domain: str = pydantic.Field()
    """
    Domain of the cloud provider and region where your Pangea project is configured. Example: if endpoint is: https://<service_name>.aws.us-west-2.pangea.cloud/v1/text/guard, the input should be: aws.us-west-2.pangea.cloud
    """

    recipe: typing.Optional[str] = pydantic.Field(default=None)
    """
    Recipe key from Pangea console defining security rules and data types to apply
    """

    overrides: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Overrides for the Pangea account
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
