# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .param_param_type import ParamParamType


class Param(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Name of the param
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of param
    """

    default: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default value or placeholder
    """

    param_type: typing.Optional[ParamParamType] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
