# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .patronus_evaluator import PatronusEvaluator
from .patronus_guardrail_config_target import PatronusGuardrailConfigTarget
from .patronus_key_auth import PatronusKeyAuth


class PatronusGuardrailConfig(UniversalBaseModel):
    """
    Patronus
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/patronus"] = pydantic.Field(
        default="integration/guardrail-config/patronus"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/patronus
    """

    auth_data: PatronusKeyAuth
    target: PatronusGuardrailConfigTarget = pydantic.Field()
    """
    Where to apply evaluation: request (evaluate user input) or response (evaluate model response)
    """

    evaluators: typing.List[PatronusEvaluator] = pydantic.Field()
    """
    The evaluators to use for the Patronus Guardrail.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
