# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .perplexity_ai_key_auth import PerplexityAiKeyAuth
from .perplexity_integrations import PerplexityIntegrations


class PerplexityAiProviderAccount(UniversalBaseModel):
    """
    Perplexity AI Provider Account
    """

    type: typing.Literal["provider-account/perplexity-ai"] = pydantic.Field(default="provider-account/perplexity-ai")
    """
    +value=provider-account/perplexity-ai
    """

    name: str = pydantic.Field()
    """
    The name of the Perplexity AI provider account
    """

    auth_data: PerplexityAiKeyAuth
    integrations: typing.List[PerplexityIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Perplexity AI provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
