# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .owned_by import OwnedBy


class PersonalAccessTokenManifest(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Personal Access Token Name
    """

    type: typing.Literal["pat"] = pydantic.Field(default="pat")
    """
    +value=pat
    """

    expiration_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Expiration Date of the Personal Access Token (should be in the ISO 8601 format)
    """

    user_fqn: str = pydantic.Field()
    """
    The fully qualified name of the user
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
