# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Poetry(UniversalBaseModel):
    """
    Use `poetry` to setup env.
    Your build context root must contain `pyproject.toml` and `poetry.lock`
    """

    type: typing.Literal["poetry"] = pydantic.Field(default="poetry")
    """
    +value=poetry
    """

    poetry_version: typing.Optional[str] = pydantic.Field(default="latest")
    """
    Poetry version to use
    """

    install_options: typing.Optional[str] = pydantic.Field(default=None)
    """
    install options to pass to poetry command
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
