# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .policy_actions import PolicyActions
from .policy_entity_types import PolicyEntityTypes
from .policy_filters import PolicyFilters
from .policy_manifest_mode import PolicyManifestMode
from .policy_manifest_operation import PolicyManifestOperation


class PolicyManifest(UniversalBaseModel):
    type: typing.Literal["policy"] = pydantic.Field(default="policy")
    """
    +value=policy
    """

    name: str = pydantic.Field()
    """
    Unique identifier of the policy across the organisation
    """

    description: str = pydantic.Field()
    """
    Description of the policy that explains what the policy does, its purpose, and how it affects resources. This helps other users understand the policy's behavior and impact.
    """

    operation: PolicyManifestOperation = pydantic.Field()
    """
    Defines if the policy validates or mutates resources. Validation policies check TrueFoundry manifests to ensure they meet conditions and can block deployments. Mutation policies modify Kubernetes manifests before they're applied to the cluster. See this [documentation](https://docs.truefoundry.com/docs/applying-custom-policies#applying-custom-policies) for more details.
    """

    mode: PolicyManifestMode = pydantic.Field()
    """
    Mode of the policy: `Audit` logs all policy evaluations without blocking deployments. `Enforce` blocks deployments if the policy fails. `Disabled` deactivates the policy.
    """

    entities: typing.List[PolicyEntityTypes] = pydantic.Field()
    """
    Types of applications this policy applies to
    """

    actions: typing.List[PolicyActions] = pydantic.Field()
    """
    Actions this policy applies to
    """

    filters: typing.Optional[PolicyFilters] = None
    code: str = pydantic.Field()
    """
    TypeScript code for Policy logic. To write and test your policy code, please refer to this [repository](https://github.com/truefoundry/tfy-typescript-policy)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
