# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PolicyManifestMode(str, enum.Enum):
    """
    Mode of the policy: `Audit` logs all policy evaluations without blocking deployments. `Enforce` blocks deployments if the policy fails. `Disabled` deactivates the policy.
    """

    AUDIT = "audit"
    ENFORCE = "enforce"
    DISABLED = "disabled"

    def visit(
        self,
        audit: typing.Callable[[], T_Result],
        enforce: typing.Callable[[], T_Result],
        disabled: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is PolicyManifestMode.AUDIT:
            return audit()
        if self is PolicyManifestMode.ENFORCE:
            return enforce()
        if self is PolicyManifestMode.DISABLED:
            return disabled()
