# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .port_app_protocol import PortAppProtocol
from .port_auth import PortAuth
from .port_protocol import PortProtocol


class Port(UniversalBaseModel):
    """
    Describes the ports the service should be exposed to.
    """

    port: int = pydantic.Field(default=80)
    """
    Port number to expose.
    """

    protocol: PortProtocol = pydantic.Field()
    """
    Protocol for the port.
    """

    expose: bool = pydantic.Field(default=True)
    """
    Expose the port
    """

    app_protocol: typing.Optional[PortAppProtocol] = pydantic.Field(default=None)
    """
    Application Protocol for the port.
    Select the application protocol used by your service. For most use cases, this should be `http`(HTTP/1.1).
    If you are running a gRPC server, select the `grpc` option.
    This is only applicable if `expose=true`.
    """

    host: typing.Optional[str] = pydantic.Field(default=None)
    """
    Host e.g. ai.example.com, app.truefoundry.com
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path e.g. /v1/api/ml/, /v2/docs/
    """

    rewrite_path_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Rewrite the path prefix to a different path.
    If `path` is `/v1/api` and `rewrite_path_to` is `/api`. The URI in the HTTP request `http://0.0.0.0:8080/v1/api/houses` will be rewritten to `http://0.0.0.0:8080/api/houses` before the request is forwarded your service.
    Defaults to `/`.
    This is only applicable if `path` is given.
    """

    auth: typing.Optional[PortAuth] = pydantic.Field(default=None)
    """
    Authentication method for inbound traffic
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
