# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PortAppProtocol(str, enum.Enum):
    """
    Application Protocol for the port.
    Select the application protocol used by your service. For most use cases, this should be `http`(HTTP/1.1).
    If you are running a gRPC server, select the `grpc` option.
    This is only applicable if `expose=true`.
    """

    HTTP = "http"
    GRPC = "grpc"
    TCP = "tcp"

    def visit(
        self,
        http: typing.Callable[[], T_Result],
        grpc: typing.Callable[[], T_Result],
        tcp: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is PortAppProtocol.HTTP:
            return http()
        if self is PortAppProtocol.GRPC:
            return grpc()
        if self is PortAppProtocol.TCP:
            return tcp()
