# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .alert_severity import AlertSeverity


class PrometheusAlertRule(UniversalBaseModel):
    """
    Prometheus Alert Rule
    """

    type: typing.Literal["prometheus-alert-rule"] = pydantic.Field(default="prometheus-alert-rule")
    """
    Type
    """

    name: str = pydantic.Field()
    """
    Enter a unique, descriptive name for your Prometheus alert rule. Choose a name that clearly indicates the condition being monitored. Please note that reserved alert names for TrueFoundry managed alerts are not allowed. For checking the list of reserved alert names, please refer to the documentation.
    """

    expression: str = pydantic.Field()
    """
    Enter a valid PromQL expression that defines the condition for triggering this alert. The alert will fire when this expression evaluates to true for the duration specified in the duration to trigger alert field.
    """

    for_: typing_extensions.Annotated[float, FieldMetadata(alias="for")] = pydantic.Field()
    """
    The prometheus expression must remain true for this duration (in seconds) before the alert is triggered. If the condition becomes false before this time elapses, the alert will not fire.
    """

    severity: AlertSeverity
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the alert rule which will be displayed in the alert rule list. This can be used to provide more context about the alert rule.
    """

    notification_enabled: bool = pydantic.Field(default=True)
    """
    When enabled, notifications will be sent to all configured target channels when the alert conditions are met.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
