# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .spark_driver_config import SparkDriverConfig
from .spark_executor_config import SparkExecutorConfig
from .task_py_spark_build import TaskPySparkBuild
from .volume_mount import VolumeMount


class PySparkTaskConfig(UniversalBaseModel):
    type: typing.Literal["pyspark-task-config"] = pydantic.Field(default="pyspark-task-config")
    """
    +value=pyspark-task-config
    """

    image: TaskPySparkBuild
    driver_config: SparkDriverConfig
    executor_config: SparkExecutorConfig
    spark_conf: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Extra configuration properties to be passed to the spark job. [Docs](https://spark.apache.org/docs/latest/configuration.html)
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Configure environment variables to be injected in the task either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    """

    mounts: typing.Optional[typing.List[VolumeMount]] = pydantic.Field(default=None)
    """
    Configure data to be mounted to Workflow pod(s) as a volume.
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    Service Account
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
