# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .python_task_config_image import PythonTaskConfigImage
from .python_task_config_mounts_item import PythonTaskConfigMountsItem
from .resources import Resources


class PythonTaskConfig(UniversalBaseModel):
    """
    Describes the configuration for the python function task
    """

    type: typing.Literal["python-task-config"] = pydantic.Field(default="python-task-config")
    """
    +value=python-task-config
    """

    image: PythonTaskConfigImage = pydantic.Field()
    """
    Specify the image spec for the task
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Configure environment variables to be injected in the task either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    """

    resources: typing.Optional[Resources] = None
    mounts: typing.Optional[typing.List[PythonTaskConfigMountsItem]] = pydantic.Field(default=None)
    """
    Configure data to be mounted to Workflow pod(s) as a volume.
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    Service Account
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
