# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .owned_by import OwnedBy
from .quay_basic_auth import QuayBasicAuth
from .quay_integrations import QuayIntegrations


class QuayProviderAccount(UniversalBaseModel):
    """
    Quay
    """

    type: typing.Literal["provider-account/quay"] = pydantic.Field(default="provider-account/quay")
    """
    +value=provider-account/quay
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the account on Quay.
    """

    auth_data: typing.Optional[QuayBasicAuth] = None
    integrations: typing.List[QuayIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
