# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .samba_nova_integrations import SambaNovaIntegrations
from .samba_nova_key_auth import SambaNovaKeyAuth


class SambaNovaProviderAccount(UniversalBaseModel):
    """
    SambaNova Provider Account
    """

    type: typing.Literal["provider-account/sambanova"] = pydantic.Field(default="provider-account/sambanova")
    """
    +value=provider-account/sambanova
    """

    name: str = pydantic.Field()
    """
    The name of the SambaNova provider account
    """

    auth_data: SambaNovaKeyAuth
    integrations: typing.List[SambaNovaIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the SambaNova provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
