# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .schedule_concurrency_policy import ScheduleConcurrencyPolicy


class Schedule(UniversalBaseModel):
    """
    Run the job on a schedule. [Docs](https://docs.truefoundry.com/docs/deploy-a-cron-job)
    """

    type: typing.Literal["scheduled"] = pydantic.Field(default="scheduled")
    """
    +value=scheduled
    """

    schedule: str = pydantic.Field()
    """
    Specify the schedule for this job to be run periodically in cron format.
    ```
    * * * * *
    | | | | |
    | | | | |___ day of week (0-6) (Sunday is 0)
    | | | |_____ month (1-12)
    | | |_______ day of month (1-31)
    | |_________ hour (0-23)
    |___________ minute (0-59)
    ```
    """

    concurrency_policy: ScheduleConcurrencyPolicy = pydantic.Field()
    """
    Choose whether to allow this job to run while another instance of the job is running, or to replace the currently running instance. Allow
    will enable multiple instances of this job to run. Forbid will keep the current instance of the job running and stop a new instance from being run.
    Replace will terminate any currently running instance of the job and start a new one.
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Timezone against which the cron schedule will be calculated, e.g. "Asia/Tokyo". Default is machine's local time.
    https://docs.truefoundry.com/docs/list-of-supported-timezones
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
