# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_tls_settings import CustomTlsSettings
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType
from .self_hosted_model_auth_data import SelfHostedModelAuthData
from .self_hosted_model_model_server import SelfHostedModelModelServer


class SelfHostedModel(UniversalBaseModel):
    """
    Self Hosted Model Integration
    """

    type: typing.Literal["integration/model/self-hosted-model"] = pydantic.Field(
        default="integration/model/self-hosted-model"
    )
    """
    +value=integration/model/self-hosted-model
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this self-hosted model in the UI
    """

    hosted_model_name: str = pydantic.Field()
    """
    The name of the hosted model
    """

    url: str = pydantic.Field()
    """
    The URL where the model is hosted
    """

    model_server: SelfHostedModelModelServer = pydantic.Field()
    """
    The type of model server being used
    """

    tfy_application_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    +uiType=Hidden
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the model
    """

    tls_settings: typing.Optional[CustomTlsSettings] = None
    auth_data: typing.Optional[SelfHostedModelAuthData] = pydantic.Field(default=None)
    """
    Self Hosted Model authentication data for the integration.
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Self Hosted Model headers for the integration. Forwarded to the provider as is. For example: `{"Authorization": "APIKey <token>"}`
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
