# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .self_hosted_model_integrations import SelfHostedModelIntegrations


class SelfHostedModelProviderAccount(UniversalBaseModel):
    """
    Self Hosted
    """

    type: typing.Literal["provider-account/self-hosted-model"] = pydantic.Field(
        default="provider-account/self-hosted-model"
    )
    """
    +value=provider-account/self-hosted-model
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    integrations: typing.List[SelfHostedModelIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    Collaborators
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
