# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .autoshutdown import Autoshutdown
from .base_service import BaseService
from .service_replicas import ServiceReplicas
from .service_rollout_strategy import ServiceRolloutStrategy


class Service(BaseService):
    """
    Describes the configuration for the service
    """

    type: typing.Literal["service"] = pydantic.Field(default="service")
    """
    +value=service
    """

    replicas: ServiceReplicas = pydantic.Field()
    """
    Deploy multiple instances of your pods to distribute incoming traffic across them, ensuring effective load balancing.
    """

    auto_shutdown: typing.Optional[Autoshutdown] = None
    allow_interception: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether to allow intercepts to be applied for this service.
    This would inject an additional sidecar in each pod of the service. Not recommended on production
    """

    rollout_strategy: typing.Optional[ServiceRolloutStrategy] = pydantic.Field(default=None)
    """
    Strategy to dictate how a rollout should happen when a new release for this service is made [Docs](https://docs.truefoundry.com/docs/rollout-strategy)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
