# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .sklearn_model_schema import SklearnModelSchema
from .sklearn_serialization_format import SklearnSerializationFormat


class SklearnFramework(UniversalBaseModel):
    type: typing.Literal["sklearn"] = pydantic.Field(default="sklearn")
    """
    Type of the framework
    """

    model_filepath: typing.Optional[str] = pydantic.Field(default=None)
    """
    Relative path to the model file in the model version contents
    """

    serialization_format: typing.Optional[SklearnSerializationFormat] = None
    model_schema: typing.Optional[SklearnModelSchema] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
