# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .owned_by import OwnedBy
from .slack_integrations import SlackIntegrations


class SlackProviderAccount(UniversalBaseModel):
    """
    Slack Provider Account
    """

    type: typing.Literal["provider-account/slack"] = pydantic.Field(default="provider-account/slack")
    """
    +value=provider-account/slack
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    integrations: typing.List[SlackIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
