# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SmtpCredentials(UniversalBaseModel):
    """
    SMTP Credentials
    """

    type: typing.Literal["smtp-credentials"] = pydantic.Field(default="smtp-credentials")
    """
    +value=smtp-credentials
    +sort=250
    """

    host: str = pydantic.Field()
    """
    The SMTP host of the email server.
    """

    username: str = pydantic.Field()
    """
    The username for the SMTP server.
    """

    password: str = pydantic.Field()
    """
    The password for the SMTP server.
    """

    port: int = pydantic.Field(default=587)
    """
    The port of the SMTP server.
    """

    tls: bool = pydantic.Field(default=True)
    """
    Whether to use TLS for the SMTP server.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
