# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class SnowflakeCortexModel(UniversalBaseModel):
    type: typing.Literal["integration/model/snowflake-cortex"] = pydantic.Field(
        default="integration/model/snowflake-cortex"
    )
    """
    +value=integration/model/snowflake-cortex
    """

    name: str = pydantic.Field()
    """
    Name to identify this Snowflake Cortex model in the UI
    """

    model_id: str = pydantic.Field()
    """
    ID of the Snowflake Cortex model to use
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the Snowflake Cortex model
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
