# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .snowflake_cortex_integrations import SnowflakeCortexIntegrations
from .snowflake_cortex_pat_token_auth import SnowflakeCortexPatTokenAuth


class SnowflakeCortexProviderAccount(UniversalBaseModel):
    """
    Snowflake Cortex Provider Account
    """

    type: typing.Literal["provider-account/snowflake-cortex"] = pydantic.Field(
        default="provider-account/snowflake-cortex"
    )
    """
    +value=provider-account/snowflake-cortex
    """

    name: str = pydantic.Field()
    """
    The name of the Snowflake Cortex provider account
    """

    auth_data: SnowflakeCortexPatTokenAuth
    account_identifier: str = pydantic.Field()
    """
    Snowflake account identifier. You can find it in the URL of your Snowflake account. Example: https://<account_identifier>.snowflakecomputing.com. Insert the account identifier only, without the URL.
    """

    integrations: typing.List[SnowflakeCortexIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Snowflake Cortex provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
