# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SparkImage(UniversalBaseModel):
    """
    Describes that we are using a pre-built image stored in a Docker Image registry
    """

    type: typing.Literal["spark-image"] = pydantic.Field(default="spark-image")
    """
    +value=spark-image
    """

    spark_version: str = pydantic.Field(default="3.5.2")
    """
    Spark version should match the spark version installed in the image.
    """

    image_uri: str = pydantic.Field()
    """
    The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
