# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .spark_driver_config import SparkDriverConfig
from .spark_executor_config import SparkExecutorConfig
from .spark_job_entrypoint import SparkJobEntrypoint
from .spark_job_image import SparkJobImage
from .volume_mount import VolumeMount


class SparkJob(UniversalBaseModel):
    type: typing.Literal["spark-job"] = pydantic.Field(default="spark-job")
    """
    +value=spark-job
    +sort=1
    """

    name: str = pydantic.Field()
    """
    Name of the job
    """

    image: SparkJobImage = pydantic.Field()
    """
    The image to use for driver and executors. Must have spark installed. Spark version must match the version in the image.
    """

    entrypoint: SparkJobEntrypoint = pydantic.Field()
    """
    Entrypoint
    """

    driver_config: SparkDriverConfig
    executor_config: SparkExecutorConfig
    env: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Configure environment variables to be injected in the service either as plain text. [Docs](https://docs.truefoundry.com/docs/env-variables)
    """

    spark_conf: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Extra configuration properties to be passed to the spark job. [Docs](https://spark.apache.org/docs/latest/configuration.html)
    """

    mounts: typing.Optional[typing.List[VolumeMount]] = pydantic.Field(default=None)
    """
    Configure volumes to be mounted to driver and executors. [Docs](https://docs.truefoundry.com/docs/mounting-volumes-job)
    """

    retries: typing.Optional[int] = pydantic.Field(default=0)
    """
    Specify the maximum number of attempts to retry a job before it is marked as failed.
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    Service Account
    """

    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fully qualified name of the workspace
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
