# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_access_key_auth import AwsAccessKeyAuth


class SqsInputConfig(UniversalBaseModel):
    """
    Describes the configuration for the input SQS worker
    """

    type: typing.Literal["sqs"] = pydantic.Field(default="sqs")
    """
    +value=sqs
    """

    queue_url: str = pydantic.Field()
    """
    AWS SQS Queue URL of Subscriber
    """

    region_name: str = pydantic.Field()
    """
    AWS Region Name
    """

    visibility_timeout: int = pydantic.Field()
    """
    A period during which Amazon SQS prevents all consumers from receiving and processing the message. If one message takes 5 seconds to process, you can set this number to 7 or any number higher than 5. This will ensure that while the message is being processed, it will not be available to other replicas. For more information, see [here](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
    """

    wait_time_seconds: int = pydantic.Field(default=19)
    """
    Wait timeout for long polling. For more information, see [here](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html)
    """

    auth: AwsAccessKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
