# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .system_message_content import SystemMessageContent


class SystemMessage(UniversalBaseModel):
    """
    System message for the chat
    """

    role: typing.Literal["system"] = pydantic.Field(default="system")
    """
    Role of the message
    """

    content: SystemMessageContent = pydantic.Field()
    """
    Text content for the system message
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the system
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
